var is_debug_webos = false;

function getApiKeyList() {

    let key = localStorage.getItem("api_key");
    if (key) return [key];
    return [];

}

function getApiKey() {
    return localStorage.getItem("api_key");
}

function writeLog(result) {
    var logData = localStorage.getItem("MasterConsoleLog");

    idcap.request("idcap://storage/file/write", {
        "parameters": {
            "data": logData,
            "path": 'file://internal/master_log.txt'
        },
        "onSuccess": function(cbObject) {
            console_log("Master Loader: log file written: " + cbObject.written + " bytes");
            result();
        },
        "onFailure": function(err) {
            console_log("Master Loader: write log onFailure : errorMessage = " + JSON.stringify(err));
            result();
        }
    });
}


function ReadMainPage(onread, onerrorread) {


    console_log("Master Loader: Read required resolve: " + "/turnip_loader.html");
    idcap.request("idcap://storage/file/exist", {
        "parameters": {
            "path": "file://internal/wgt-private/turnip_loader.html"
        },
        "onSuccess": function(cbObject) {
            if (cbObject.exists) {
                let href = window.location.href;
                let dir = href.substring(0, href.lastIndexOf('/'));
                console_log("Master Loader: Fire read resolve:  : " + JSON.stringify(cbObject));
                writeLog(function() {
                    onread(site_path + "wgt-private/turnip_loader.html?serv=" + getServerUrl() + (widget_version ? '&wvers=' + widget_version : '') + '&lvers=' + getLoaderVersion() + '&loader=' + dir + (is_widget_loaded ? "&iswload=1" : ""));

                });
                return;
            }
            onerrorread("Loader not found.");
        },
        "onFailure": function(err) {
            console_log("Master Loader: Read Page Failure : errorMessage = " + JSON.stringify(err));
            onerrorread("Loader found error.");
        }
    });
}

function LoadWidget(docObj, callback, onerror) {

    console_log("Master Loader Widget in " + docObj);
    var ub = getServerUrl();

    var widgetDir;

    idcap.request("idcap://storage/file/list", {
        "parameters": {
            "path": "file://internal"
                // List files in the internal memory
        },
        "onSuccess": function(cbObject) {
            console_log("Master Loader: exists widget files : " + JSON.stringify(cbObject));
            console_log("\nfileList : " + JSON.stringify(cbObject.fileList));
            console_log("\ntotalCount : " + JSON.stringify(cbObject.totalCount));

            makeSite(cbObject.fileList, function() {
                    loadWebOSWidgetContexts(callback, onerror);
                    return;
                },
                function(err) {
                    console_log("Master Loader: makeSite onFailure : errorMessage = " + JSON.stringify(err));
                    onerror("makeSite onFailure : errorMessage = " + JSON.stringify(err));
                });


        },
        "onFailure": function(err) {
            console_log("Master Loader: Loader File List onFailure : errorMessage = " + JSON.stringify(err));
            onerror("Loader File List onFailure : errorMessage = " + JSON.stringify(err));
        }
    });

    var dir_count = 0;

    function makeSite(files, oncompleted, onerror) {
        if (files === null || files.length === 0) {
            oncompleted();
            return;
        }
        let dir = ['wgt-private', 'images', 'documents', 'downloads'];
        dir_count = dir.length;
        for (let i = 0; i < dir.length; i++) {


            makeDir(files, dir[i],

                function(e) {
                    if (!e) {

                        idcap.request("idcap://storage/file/mkdir", {
                            "parameters": {
                                "path": "file://internal/" + dir[i]
                            },
                            "onSuccess": function() {
                                console_log("Widget Loader: Create dir Success " + dir_count + " - " + dir[i]);
                                dir_count--;
                                if (dir_count === 0)
                                    oncompleted();
                            },
                            "onFailure": function(err) {
                                console_log("Widget Loader: Create dir onFailure " + dir[i] + " : errorMessage = " + JSON.stringify(err));
                                onerror(JSON.stringify(err));
                            }
                        });
                    } else {

                        console_log("Widget Loader: dir already exist " + dir_count + " - " + dir[i]);
                        dir_count--;
                        if (dir_count === 0)
                            oncompleted();
                    }

                },
                function(err) {
                    console_log("Master Loader: makeSite onFailure : errorMessage = " + JSON.stringify(err));
                    onerror("makeSite onFailure : errorMessage = " + err);
                });
        }
    }

    var del_count = 0;
    //    const max_portion = 20;

    function makeDir(files, dir, onmake, onerr) {
        if (files.filter(item => item.type === 'D' && item.name === dir).length > 0) {

            if (dir === 'wgt-private' && loader_version && loader_version === getLoaderVersion()) {
                idcap.request("idcap://storage/file/list", {
                    "parameters": {
                        "path": "file://internal/wgt-private"
                            // List files in the internal memory
                    },
                    "onSuccess": function(cbObject) {
                        console_log("Master Loader: exists wgt-private for delete files : " + JSON.stringify(cbObject));
                        console_log("\nfileList : " + JSON.stringify(cbObject.fileList));
                        console_log("\ntotalCount : " + JSON.stringify(cbObject.totalCount));

                        if (cbObject.totalCount > 0) {
                            var del_list = cbObject.fileList.filter(item => item.type !== 'D');
                            del_count = del_list.length;
                            console_log("\ndelCount : " + del_count);

                            if (del_count === 0) return onmake(true);


                            /*                          let portion_cnt = Math.ceil(del_count / max_portion);
 
                        	let portion_array = max_portion < del_count ? del_list.slice(0, max_portion) : del_list.slice(0);
 
                        	delete_wgt_files(0, portion_array, del_list);*/

                            for (var i = 0; i < cbObject.fileList.length; i++) {
                                console_log("\ncbObject.fileList[i].name: " + cbObject.fileList[i].name);
                                console_log(" / cbObject.fileList[i].type: " + cbObject.fileList[i].type);
                                console_log(" / cbObject.fileList[i].size: " + cbObject.fileList[i].size);
                                if (cbObject.fileList[i].type !== 'D') {

                                    console_log("Master Loader: Delete file in wgt-private: " + cbObject.fileList[i].name);
                                    idcap.request("idcap://storage/file/remove", {
                                        // removing a Directory or file
                                        "parameters": {
                                            "path": "file://internal/wgt-private/" + cbObject.fileList[i].name,
                                            "recursive": false
                                        },
                                        "onSuccess": function() {
                                            console_log("Master Loader: Delete file in wgt-private Success " + del_count);
                                            del_count--;
                                            if (del_count <= 0)
                                                onmake(true);

                                        },
                                        "onFailure": function(err) {
                                            console_log("Master Loader: Delete file in wgt-private onFailure : errorMessage = " + JSON.stringify(err));
                                            onerr(JSON.stringify(err));
                                        }
                                    });
                                }
                            }
                        } else {

                            onmake(true);

                        }

                    },
                    "onFailure": function(err) {
                        console_log("Master Loader: Loader File List onFailure : errorMessage = " + JSON.stringify(err));
                        onerror("Loader File List onFailure : errorMessage = " + JSON.stringify(err));
                    }
                });

                return;
            }
            onmake();

/*            console_log("Master Loader: Delete dir: " + dir);
            idcap.request("idcap://storage/file/remove", {
                // removing a Directory or file
                "parameters": {
                    "path": "file://internal/" + dir,
                    "recursive": true
                },
                "onSuccess": function() {
                    console_log("Master Loader: Delete dir Success " + dir);
                    onmake();
                },
                "onFailure": function(err) {
                    console_log("Master Loader: Delete Dir " + dir + " onFailure : errorMessage = " + JSON.stringify(err));
                    onerr(JSON.stringify(err));
                }
            });*/
        } else {
            onmake();
        }

    }


    var list_down = [];
 
    function loadWebOSWidgetContexts(callback, onerror) {
        console_log("Master Loader Load widget context");
        //down_count = 1;

        document.addEventListener(
            "idcap::file_downloaded",
            function(param) {
                console_log(
                    "Event 'file_downloaded' is received.\n" +
                    "Result = " + param.result + "\n" +
                    "Error message = " + param.errorMessage + "\n" +
                    "uri = " + param.uri + "\n" +
                    "Download path = " + param.downloadPath
                );
                
                //bug to double call
                if(list_down.includes(param.downloadPath)) return;
                list_down.push(param.downloadPath);

                if (!param.result) return onerror(param.errorMessage);

                console_log("Master Loader Widget Received completed : " + param.downloadPath);



                extractResource(param.downloadPath, function(e) {


                    if (param.downloadPath.indexOf("widget_content.zip") >= 0) {

                        var filecss_count = docObj.length;

                        docObj.forEach(entry => {

                            decodeBase("file://internal/wgt-private/" + entry,
                                function(e) {

                                    filecss_count--;
                                    if (filecss_count <= 0) {

                                            check_load_loader(function(e) {
                                                if (!e) {

                                                    downloadWidget("widget_base.zip",
                                                        function() {
                                                            console_log("Master Loader Widget Zip File Resource Downloaded " + entry);
                                                        },
                                                        function(e) {
                                                            console_log("Master Loader Widget download Error " + e);
                                                            onerror("Widget download error " + e);
                                                        }, true);
                                                }else{

                                                	return callback();
                                               	
                                                }
                                            });

                                     }
                                },
                                function(e) {
                                    console_log("Master Loader Widget decode error : " + e);
                                    onerror("Master Loader Widget decode error " + e);
                                });

                        });

                    } else {

                    		return callback();

                    }

                }, function(e) {
                    onerror(e);
                })

            },
            false
        );

        filecss_count = docObj.length;

        downloadWidget("widget_content.zip",
            function() {
                console_log("Master Loader Widget Content Zip File Resource Downloaded " + entry);
            },
            function(e) {
                console_log("Master Loader Widget Content download Error " + e);
                onerror("Widget download error " + e);
            }, false);



    }


    //Check exist idcap lib

    function check_load_loader(result) {

        if (!loader_version) return result(false);

        idcap.request("idcap://storage/file/exist", {
            "parameters": {
                "path": "file://internal/wgt-private/js/idcap.js"
            },
            "onSuccess": function(cbObject) {
                console.log("Check exist idcap lib : " + JSON.stringify(cbObject));
                console.log("\nCheck exist idcap lib: " + cbObject.exists);
                if (cbObject.exists) {
                    if (loader_version !== getLoaderVersion()) return result(false);
                }
                return result(cbObject.exists);
            },
            "onFailure": function(err) {
                console.log("onFailure Check exist idcap lib : errorMessage = " + err.errorMessage);
                return result(false);
            }
        });

    }





    function downloadWidget(item, callback, error, is_base) {

        let ub = getServerUrl();

        let url = replaceAll(ub, "https://", "http://") + (is_base ? ("widget_base/"  + item) : "api/command/GetWidgetContent");

        console_log("Master Loader downloadWidget start: " + url);

        idcap.request("idcap://storage/file/download", {
            "parameters": {
                "action": 'start',
                "source": url,
                "destination": 'file://internal/wgt-private/' + item,
                "httpOption": {
                    "maxRedirection": 5,
                    "headers": {
                        "Cache-Control": "no-cache"
                    }
                }
            },
            "onSuccess": function(cbObject) {
                console_log("File Download Start.");
                console_log("Ticket: " + cbObject.ticket);
                callback();
            },
            "onFailure": function(err) {
                console_log("Master Loader Widget Received onFailure : errorMessage = " + JSON.stringify(err));
                error(err.errorMessage);
            }
        });

    }



    function extractResource(zipfile, onsuccess, onerror) {
        document.addEventListener(
            "idcap::file_unzipped",
            function(param) {
                console_log(
                    "Event 'file_unzipped' is received.\n" +
                    "Result = " + param.result + "\n" +
                    "Error message = " + param.errorMessage + "\n" +
                    "zipPath = " + param.zipPath + "\n" +
                    "targetPath = " + param.targetPath + "\n"
                );
                /*    	               idcap.request( "idcap://storage/file/list" , {
                    	                    "parameters": {
                    	                        "path" : "file://internal/wgt-private/"
                    	                        // List files in the internal memory
                    	                    },
                    	                    "onSuccess": function (cbObject) {
                    	                        console.log("cbObject : " + JSON.stringify(cbObject));
                    	                        console.log("\ncbObject.fileList : " + JSON.stringify(cbObject.fileList));
                    	                        console.log("\ncbObject.totalCount : " + JSON.stringify(cbObject.totalCount));
                    	                        for (var i = 0; i < cbObject.fileList.length; i++) {
                    	                            console.log("\ncbObject.fileList[i].name: " + cbObject.fileList[i].name);
                    	                            console.log(" / cbObject.fileList[i].type: " + cbObject.fileList[i].type);
                    	                            console.log(" / cbObject.fileList[i].size: " + cbObject.fileList[i].size);
                    	                        }
                    	                    },
                    	                    "onFailure": function (err) {
                    	                        console.log("onFailure : errorMessage = " + err.errorMessage);
                    	                    }
                    	                });*/
                //            	document.removeEventListener("idcap::file_unzipped", unzipEvent);
                idcap.request("idcap://storage/file/remove", {
                    // removing a Directory or file
                    "parameters": {
                        "path": "file://internal/wgt-private/" + zipfile,
                        "recursive": false
                    },
                    "onSuccess": function() {
                        console_log("Master Loader Resource Success arhive deleted");
                        onsuccess();
                    },
                    "onFailure": function(err) {
                        console_log("Master Loader Resource delete zip onFailure : errorMessage = " + JSON.stringify(err) + ". Execution continue");
                        onsuccess();
                    }
                });

            },
            false
        );
        idcap.request("idcap://storage/file/unzip", {
            "parameters": {
                "zipPath": zipfile,
                "targetPath": "file://internal/wgt-private/"
            },
            "onSuccess": function() {
                console_log("Master Loader Resource Success start unzip " + zipfile);
            },
            "onFailure": function(err) {
                console_log("Master Loader Resource start unzip onFailure : errorMessage = " + JSON.stringify(err));
                onerror(err.errorMessage);
            }
        });
    }

    function decodeBase(file, ondecode, onerror) {
        let ext = file.split('.').pop();
        console.log("Decode file extention = " + ext);
        if (ext !== "html") {
            ondecode();
            return;
        }
        //    console.log("Decode file = " + file);

        idcap.request("idcap://storage/file/read", {
            "parameters": {
                "path": file,
                "position": 0
            },
            "onSuccess": function(cbObject) {
                // If file is read as text, utf encoded string will be returned.
                // Create an image element, and set the source as the binary data.
                //console.log("DecodeBase Read file " + cbObject.data);

                let data = replaceAll(cbObject.data, "href=\"/css/", "href=\"css/");
                data = replaceAll(data, "src=\"/js/", "src=\"js/");
                data = replaceAll(data, "src='/images/", "src='images/");
                data = replaceAll(data, "src=\"/images/", "src=\"images/");
                data = replaceAll(data, '.js?ts"></script>', '.js?ts=' + (Date.now().toString()) + '"></script>');

                console_log("Master Loader Decode write file = " + file);

                idcap.request("idcap://storage/file/write", {
                    "parameters": {
                        "data": data,
                        "path": file,
                        "position": 0,
                        "mode": 'truncate',
                        "offset": 0
                    },
                    "onSuccess": function(cbObject) {
                        //                       console.log("Decode Write file cbObject : " + JSON.stringify(cbObject));
                        console_log("Master Loader Decode Write file " + file + " written: " + cbObject.written + " bytes");
                        ondecode();
                    },
                    "onFailure": function(err) {
                        console_log("Master Loader Decode Write file onFailure : errorMessage = " + JSON.stringify(err));
                        onerror(JSON.stringify(err));
                    }
                });

            },
            "onFailure": function(err) {
                console_log("Master Loader Decode onFailure : errorMessage = " + JSON.stringify(err));
                onerror(JSON.stringify(err));
            }
        });


    }


}

function rebootDevice() {
    idcap.request("idcap://power/command", {
        "parameters": {
            "powerCommand": "reboot"
        },
        "onSuccess": function() {
            console_log("Master Loader: rebootDevice onSuccess");
        },
        "onFailure": function(err) {
            console_log("Master Loader: rebootDevice onFailure : errorMessage = " + JSON.stringify(err));
        }
    });
}

function beforeRun(result) {
    //    document.getElementById('test').innerHTML += "beforeRun" + "<br/>";

    document.addEventListener(
        "idcap::property_changed",
        function(param) {
            console_log(
                "Master Loader: Event 'property_changed' is received.\n" +
                "Changed Property = " + param.key);
            if (param.key === 'tv_name') {
                if (set_int) {
                    clearTimeout(set_int);
                    set_int = null;
                }
                setTimeout(setTVProperty(function(e) {
                    if (!e) {
                        console_log("Master Loader: Error Changed Property = " + param.key);
                        result();
                        //                rebootDevice();
                    }
                }), 1000);

            }
            if (param.key === 'isBrowserDebugMode' && set_array.includes('isBrowserDebugMode')) {
                set_counter--;
                is_reboot = true;
                if (set_counter === 0)
                    result();

            }
            if (param.key === 'tv_channel_attribute_floating_ui' && set_array.includes('tv_channel_attribute_floating_ui')) {
                set_counter--;
                if (set_counter === 0)
                    result();

            }
            if (param.key === 'display_resolution' && set_array.includes('display_resolution')) {
                set_counter--;
                is_reboot = true;
                if (set_counter === 0)
                    result();

            }
            if (param.key === 'boot_sequence_option' && set_array.includes('boot_sequence_option')) {
                set_counter--;
                is_reboot = true;
                if (set_counter === 0)
                    result();

            }
            if (param.key === 'tv_channel_ui' && set_array.includes('tv_channel_ui')) {
                set_counter--;
                if (set_counter === 0)
                    result();

            }

            //if (param.key === 'instant_power') {
                //                       if (set_power) {
                //                           console.log("Set instant_power mode = 2 success");
                //                           workPower();
                //                       }
                //                       else {
                /*idcap.request("idcap://power/powermode/get", {
                    "parameters": {},
                    "onSuccess": function (s) {
                        console.log("Get power mode " + s.mode);

                    },
                    "onFailure": function (err) {
                        console.log("get power mode onFailure : errorMessage = " + JSON.stringify(err));
                    }
                });*/

                //                       }
            //}
        },
        false
    );


    var set_int = null;

    getTVProperty(function(err) {
        if (!err) {
            if (set_array.length > 0) {


                set_counter = set_array.length;
                set_int = setTimeout(setTVProperty(function(e) {
                    if (!e) {
                        //                        document.getElementById('test').innerHTML += "Error Changed Property = " + param.key + "<br/>";
                        console_log("Master Loader: Error Changed Property = " + param.key);
                        result();
                        //                rebootDevice();
                    }
                }), 12000);
            } else {
                console_log("Master Loader: Properties alredy set");
                result();
            }
        } else {
            console_log("Master Loader: Properties  set error");
            set_array = [];
            result();
        }




    });
}


function getTVProperty(result) {

    var get_count = is_debug_webos ? 5 : 4;
    console_log("Master Loader: ==GET TVProperty");
    //document.getElementById('test').innerHTML += "==GET TVProperty " + "<br/>";

    if(is_debug_webos){
	    idcap.request("idcap://configuration/property/get", {
	        "parameters": {
	            "key": "browser_debug_mode"
	        },
	        "onSuccess": function(cbObject) {
	            console_log("Master Loader: debug mode = " + cbObject.value);
	            //            document.getElementById('test').innerHTML += "debug mode = " + cbObject.value + "<br/>";
	            if (cbObject.value === "0") {
	            	//TODO отключено
	                set_array.push('isBrowserDebugMode');
	            }
	            get_count--;
	            if (get_count === 0)
	                result();
	        },
	        "onFailure": function(err) {
	            console_log("Master Loader: Set debug mode onFailure : errorMessage = " + JSON.stringify(err));
	            //            document.getElementById('test').innerHTML += "Set debug mode onFailure " + JSON.stringify(err) + "<br/>";
	            result(JSON.stringify(err));
	        }
	    });
    }

    idcap.request("idcap://configuration/property/get", {
        "parameters": {
            "key": "tv_channel_attribute_floating_ui"
        },
        "onSuccess": function(cbObject) {
            console.log("Master Loader: tv_channel_attribute_floating_ui = " + cbObject.value);
            //            document.getElementById('test').innerHTML += "tv_channel_attribute_floating_ui = " + cbObject.value + "<br/>";
            if (cbObject.value === "1") {
                set_array.push('tv_channel_attribute_floating_ui');
            }
            get_count--;
            if (get_count === 0)
                result();

        },
        "onFailure": function(err) {
            console.log("Master Loader: Get tv_channel_attribute_floating_ui onFailure : errorMessage = " + JSON.stringify(err));
            //            document.getElementById('test').innerHTML += "Get tv_channel_attribute_floating_ui onFailure : errorMessage = " + JSON.stringify(err) + "<br/>";
            result(JSON.stringify(err));
        }
    });
    idcap.request("idcap://configuration/property/get", {
        "parameters": {
            "key": "display_resolution"
        },
        "onSuccess": function(cbObject) {
            console_log("Master Loader: display_resolution = " + cbObject.value);
            //            document.getElementById('test').innerHTML += "display_resolution = " + cbObject.value + "<br/>";
            if (cbObject.value !== "1920x1080") {
                set_array.push('display_resolution');
            }
            get_count--;
            if (get_count === 0)
                result();

        },
        "onFailure": function(err) {
            console_log("Master Loader: get display_resolution onFailure : errorMessage = " + JSON.stringify(err));
            //            document.getElementById('test').innerHTML += "get display_resolution onFailure : errorMessage = " + JSON.stringify(err) + "<br/>";
            result(JSON.stringify(err));
        }
    });
    idcap.request("idcap://configuration/property/get", {
        "parameters": {
            "key": "boot_sequence_option"
        },
        "onSuccess": function(cbObject) {
            console_log("Master Loader: boot_sequence_option = " + cbObject.value);
            //            document.getElementById('test').innerHTML += "boot_sequence_option = " + cbObject.value + "<br/>";
            if (cbObject.value !== "1") {
                set_array.push('boot_sequence_option');
            }
            get_count--;
            if (get_count === 0)
                result();

        },
        "onFailure": function(err) {
            console_log("Master Loader: get boot_sequence_option onFailure : errorMessage = " + JSON.stringify(err));
            //            document.getElementById('test').innerHTML += "get boot_sequence_option onFailure : errorMessage = " + JSON.stringify(err) + "<br/>";
            result(JSON.stringify(err));
        }
    });
    idcap.request("idcap://configuration/property/get", {
        "parameters": {
            "key": "tv_channel_ui"
        },
        "onSuccess": function(cbObject) {
            console_log("Master Loader: tv_channel_ui = " + cbObject.value);
            //            document.getElementById('test').innerHTML += "boot_sequence_option = " + cbObject.value + "<br/>";
            if (cbObject.value !== "0") {
                set_array.push('tv_channel_ui');
            }
            get_count--;
            if (get_count === 0)
                result();

        },
        "onFailure": function(err) {
            console_log("Master Loader: get boot_sequence_option onFailure : errorMessage = " + JSON.stringify(err));
            //            document.getElementById('test').innerHTML += "get boot_sequence_option onFailure : errorMessage = " + JSON.stringify(err) + "<br/>";
            result(JSON.stringify(err));
        }
    });

}

function setTVProperty(result) {

    console_log("Master Loader: ==SET TVProperty");
    //    document.getElementById('test').innerHTML += "==SET TVProperty " + "<br/>";

    if (set_array.includes('isBrowserDebugMode'))
        idcap.request("idcap://configuration/property/set", {
            "parameters": {
                "key": "browser_debug_mode",
                "value": "1"
            },
            "onSuccess": function() {
                console_log("Master Loader: Set debug mode start success");
                //               document.getElementById('test').innerHTML += "Set debug mode start success<br/>";
            },
            "onFailure": function(err) {
                console_log("Master Loader: Set debug mode onFailure : errorMessage = " + JSON.stringify(err));
                //                document.getElementById('test').innerHTML += "Set debug mode onFailure<br/>";
                result(JSON.stringify(err));
            }
        });


    if (set_array.includes('tv_channel_attribute_floating_ui'))
        idcap.request("idcap://configuration/property/set", {
            "parameters": {
                "key": "tv_channel_attribute_floating_ui",
                "value": "0"
            },
            "onSuccess": function() {
                console_log("Master Loader: Hide tv_channel_attribute_floating_ui start onSuccess");
                //               document.getElementById('test').innerHTML += "Hide tv_channel_attribute_floating_ui start onSuccess<br/>";
            },
            "onFailure": function(err) {
                console_log("Master Loader : Hide attribute floating_ui channel onFailure : errorMessage = " + JSON.stringify(err));
                //                document.getElementById('test').innerHTML += "Hide attribute floating_ui channel onFailure : errorMessage = " + JSON.stringify(err) + "<br/>";
                result(JSON.stringify(err));
            }
        });


    if (set_array.includes('display_resolution'))
        idcap.request("idcap://configuration/property/set", {
            "parameters": {
                "key": "display_resolution",
                "value": "1920x1080"
            },
            "onSuccess": function() {
                console_log("Master Loader: set display_resolution onSuccess");
                //                document.getElementById('test').innerHTML += "set display_resolution start onSuccess<br/>";
            },
            "onFailure": function(err) {
                console_log("Master Loader: set display_resolution : errorMessage = " + JSON.stringify(err));
                //                document.getElementById('test').innerHTML += "set display_resolution onFailure : errorMessage = " + JSON.stringify(err) + "<br/>";
                result(JSON.stringify(err));
            }
        });

    if (set_array.includes('boot_sequence_option'))
        idcap.request("idcap://configuration/property/set", {
            "parameters": {
                "key": "boot_sequence_option",
                "value": "1"
            },
            "onSuccess": function() {
                console.log("Master Loader: set boot_sequence_option onSuccess");
                //                document.getElementById('test').innerHTML += "set boot_sequence_option start onSuccess<br/>";
            },
            "onFailure": function(err) {
                console_log("Master Loader: set boot_sequence_option : errorMessage = " + JSON.stringify(err));
                //                document.getElementById('test').innerHTML += "set boot_sequence_option onFailure : errorMessage = " + JSON.stringify(err) + "<br/>";
                result(JSON.stringify(err));
            }
        });
    if (set_array.includes('tv_channel_ui'))
        idcap.request("idcap://configuration/property/set", {
            "parameters": {
                "key": "tv_channel_ui",
                "value": "0"
            },
            "onSuccess": function() {
                console_log("Master Loader: Set tv_channel_ui start success");
            },
            "onFailure": function(err) {
                console_log("Master Loader: Set tv_channel_ui onFailure : errorMessage = " + JSON.stringify(err));
                result(JSON.stringify(err));
            }
        });
}

function getXAITVersion(onSuccess, onError) {
    idcap.request("idcap://configuration/property/get", {
        "parameters": {
            "key": "xait_version"
        },
        "onSuccess": function(cbObject) {
            console_log("Master Loader: Xait Version onSuccess cbObject = " + JSON.stringify(cbObject), "color: cyan;");
            document.getElementById('test').innerHTML += "cXait Version onSuccess cbObject = " + JSON.stringify(cbObject) + "<br/>";
            if (onSuccess)
                onSuccess(cbObject);
        },
        "onFailure": function(err) {
            console_log("Master Loader: Xait Version onFailure : errorMessage = " + JSON.stringify(err));
            if (onError)
                onError(err.errorMessage);
        }
    });
}

function setWidgetFiles(str) {
    idcap.request("idcap://storage/file/write", {
        "parameters": {
            "data": "[" + str + "]",
            "path": 'file://internal/widget_files.txt'
        },
        "onSuccess": function(cbObject) {
            console_log("Master Loader: setWidgetFiles written: " + cbObject.written + " bytes");
        },
        "onFailure": function(err) {
            console_log("Master Loader: setWidgetFiles onFailure : errorMessage = " + JSON.stringify(err));
        }
    });
}



//Промис-обёртка для idcap.request
function idcapRequest(uri, parameters) {
    return new Promise(function (resolve, reject) {
        try {
            idcap.request(uri, {
                parameters: parameters || {},
                onSuccess: function (res) { resolve(res); },
                onFailure: function (err) { reject(err); }
            });
        } catch (ex) {
            reject(ex);
        }
    });
}

// Гарантированно установить конфигурационное свойство: если свойства нет или значение отличается — установить.
async function ensureConfigProperty(key, desiredValue) {
    try {
        const getRes = await idcapRequest("idcap://configuration/property/get", { key: key });
        // Некоторые телевизоры возвращают { value: "..." } или полную структуру — безопасно извлекаем
        const current = (getRes && typeof getRes.value !== 'undefined') ? getRes.value : getRes;
        if (String(current) === String(desiredValue)) {
            console.log("ensureConfigProperty: property already set", key, current);
            return { changed: false, current: current };
        }
    } catch (getErr) {
        // Если get упал — логируем и пытаемся установить всё равно
        console.warn("ensureConfigProperty: get failed for", key, getErr);
    }

    try {
        await idcapRequest("idcap://configuration/property/set", { key: key, value: String(desiredValue) });
        console.log("ensureConfigProperty: property set", key, desiredValue);
        return { changed: true, current: desiredValue };
    } catch (setErr) {
        console.error("ensureConfigProperty: failed to set", key, setErr);
        throw setErr;
    }
}


// Пример использования:
async function setProperties() {
    try {
        // Убедиться, что уровень прозрачности OSD = 0
        await ensureConfigProperty("osd_transparency_level", "0");

        // Убедиться, что instant_power = 2
        await ensureConfigProperty("instant_power", "2");

        // Убедиться, что Pro:Centric указывает на нужный домен
        await ensureProCentricServer("portal.example.com");

        console.log("ensure settings done");
    } catch (e) {
        console.error("Ошибка при установке параметров:", e);
    }
}

// Подписка на событие изменения свойств (опционально)
document.addEventListener("idcap::property_changed", function (evt) {
    console.log("idcap::property_changed", evt);
}, false);