function getApiKeyList() {

    let key = localStorage.getItem("api_key");
    if (key) return [key];
    return [];

}

function getApiKey() {
    return localStorage.getItem("api_key");
}


function ReadMainPage(onread, onerrorread) {

    console_log("Master Loader: Read required resolve: " + "wgt-private/turnip_loader.html");
    let dir = TurnIpJSLib.get_base_path() + "/wgt-private/turnip_loader.html";
    if (TurnIpJSLib.file_exist(dir)) {
        console_log("Master Loader: Fire read resolve: " + dir);
        onread(dir + "?serv=" + getServerUrl() + (widget_version ? '&wvers=' + widget_version : '') + '&lvers=' + getLoaderVersion());
        return;
    }
    onerrorread("Master Loader: not found /wgt-private/turnip_loader.html");
}

var android_path;

function LoadWidget(docObj, callback, onerror) {

    var filecss_count = docObj.length;

    android_path = TurnIpJSLib.get_base_path();

    console.log("Master Loader Widget in " + docObj);
    console_log("Master Loader Widget base_path " + android_path);

    var widgetDir;

    TurnIpJSLib.clear_workdir("wgt-private");

    loadWidgetContexts();

    function loadWidgetContexts() {

 //       let url = replaceAll(getServerUrl(), "https://", "http://") + "widget_content/widget_content.zip";
 //       let app_data = getApiKey();
        let url = replaceAll(getServerUrl(), "https://", "http://") + "api/command/GetWidgetContent";
        console_log("Master Loader: downloadWidget :" + url);

        if (!TurnIpJSLib.download_file(url, "wgt-private/widget_content.zip")) {
            console_log("Master Loader : error download file widget_content.zip");
            onerror("Master Loader : error download file widget_content.zip");
            return;
        }

        let dir = android_path + "/wgt-private/";
        let file = dir + "widget_content.zip";
        if (TurnIpJSLib.extract_zip(file, dir)) {

            docObj.forEach(entry => {
                decodeAndroid("/wgt-private/" + entry);
            });

            callback(dir);
            return;

        }
        console_log("Master Loader: error extract widget_content.zip");
        onerror("Master Loader: error extract widget_content.zip");
    }

    /*    function loadWidgetContexts() {
            console_log("Master Loader: Load widget context");
            docObj.forEach(entry => {
                console_log("Master Loader Widget Load Documents - Find to download " + entry);
                downloadWidget(entry,
                    function() {
                        console_log("Master Loader Widget File Downloaded " + entry);
                        filecss_count--;
                        if (filecss_count <= 0) {
                            callback();
                            return;
                        }
                    },
                    function(e) {
                        console_log("Master Loader Widget download Error " + e);
                        onerror("Widget download error " + e);
                    });
                //                }

            });
        }

        function downloadWidget(item, callback, error) {

            let ub = getServerUrl();

            let url = replaceAll(ub, "https://", "http://") + "widget_content/" + item;
            console_log("Master Loader downloadWidget :" + url);
            
            let res = TurnIpJSLib.download_file(url, "wgt-private/" + item);
           if(res){
                console.log("result download_file: ok");
           	decodeAndroid("/wgt-private/" + item);
            	callback();
            }else{
                console_log("Master Loader downloadWidget error");
                error("Master Loader downloadWidget error");
           	
            }

        }*/

    function decodeAndroid(file) {

        let ext = file.split('.').pop();
        if (ext !== "html") {
            return;
        }
        console_log("Decode file extention = " + file);

        let data = TurnIpJSLib.read_file(file);
        if (data.length === 0) {
            console_log("Decode error read file " + file);
            return;
        }



        data = replaceAll(data, "href=\"/css/", "href=\"" + android_path + "/css/");
        data = replaceAll(data, "src=\"/js/", "src=\"" + android_path + "/js/");
        data = replaceAll(data, "src='/images/", "src='" + android_path + "/images/");
        data = replaceAll(data, "src=\"/images/", "src=\"" + android_path + "/images/");

        data = replaceAll(data, '<script src="turnip_utils.js">', '<script src="turnip_utils.js"></script><script src="turnip_helper_android.js"></script><script src="turnip_channel_android.js"></script><script src="turnip_portal_files_android.js"></script><script src="turnip_portal_resource_android.js">');

        if (!TurnIpJSLib.save_file(file, data)) {
            console_log("Decode error write file " + file);
            return;
        }

    }



}

function beforeRun(result) {

    var aliases = getApiKey();

    if (aliases === null) {
        widget_version = null;
    } else {
        appID = aliases;

        console_log("Master Loader appID check: " + appID);

    }

    result();
}